<?php
/** @var $user   \app\models\User */
/** @var $client \app\models\Client */

$this->title = 'My Profile';
$changePasswordUrl = \yii\helpers\Url::to(['/client/change-password']);
$csrfParam = Yii::$app->request->csrfParam;
$csrfToken = Yii::$app->request->csrfToken;
?>

<div class="container-fluid py-3" style="max-width:800px;">

    <h4 class="fw-bold mb-1">
        <i class="bi bi-person-circle text-primary me-2"></i>My Profile
    </h4>
    <p class="text-muted small mb-4">View your account information and change your password.</p>

    <!-- Account Info -->
    <div class="card border-0 shadow-sm rounded-4 mb-4">
        <div class="card-header bg-white border-0 px-4 pt-4 pb-0">
            <h6 class="fw-bold mb-3">
                <i class="bi bi-person-badge text-primary me-2"></i>Account Information
            </h6>
        </div>
        <div class="card-body px-4 pb-4 pt-0">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">FULL NAME</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($user->name) ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">USERNAME</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($user->username ?: '—') ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">EMAIL</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($user->email) ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">PHONE</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($user->phone ?: '—') ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Client Info -->
    <div class="card border-0 shadow-sm rounded-4 mb-4">
        <div class="card-header bg-white border-0 px-4 pt-4 pb-0">
            <h6 class="fw-bold mb-3">
                <i class="bi bi-building text-success me-2"></i>Client Details
            </h6>
        </div>
        <div class="card-body px-4 pb-4 pt-0">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label small fw-bold text-muted">CLIENT NO</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->no ?: '—') ?>
                    </div>
                </div>
                <div class="col-md-9">
                    <label class="form-label small fw-bold text-muted">CLIENT NAME</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->name) ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label small fw-bold text-muted">PHONE</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->phone ?: '—') ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label small fw-bold text-muted">TOWN</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->town ?: '—') ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label small fw-bold text-muted">COUNTRY</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->country ?: '—') ?>
                    </div>
                </div>
                <div class="col-md-12">
                    <label class="form-label small fw-bold text-muted">ADDRESS</label>
                    <div class="form-control bg-light border-0 rounded-3">
                        <?= htmlspecialchars($client->address ?: '—') ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Change Password -->
    <div class="card border-0 shadow-sm rounded-4" id="changePasswordCard">
        <div class="card-header bg-white border-0 px-4 pt-4 pb-0">
            <h6 class="fw-bold mb-3">
                <i class="bi bi-lock text-danger me-2"></i>Change Password
            </h6>
        </div>
        <div class="card-body px-4 pb-4 pt-0">

            <!-- Alert area -->
            <div id="pwAlert" class="d-none mb-3"></div>

            <div class="row g-3">
                <div class="col-md-12">
                    <label class="form-label small fw-bold text-muted">
                        CURRENT PASSWORD <span class="text-danger">*</span>
                    </label>
                    <input type="password" id="current_password"
                           class="form-control shadow-sm rounded-3"
                           placeholder="Enter your current password"
                           autocomplete="current-password">
                </div>
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">
                        NEW PASSWORD <span class="text-danger">*</span>
                    </label>
                    <input type="password" id="new_password"
                           class="form-control shadow-sm rounded-3"
                           placeholder="Min. 6 characters"
                           autocomplete="new-password">
                </div>
                <div class="col-md-6">
                    <label class="form-label small fw-bold text-muted">
                        CONFIRM NEW PASSWORD <span class="text-danger">*</span>
                    </label>
                    <input type="password" id="confirm_password"
                           class="form-control shadow-sm rounded-3"
                           placeholder="Repeat new password"
                           autocomplete="new-password">
                </div>
                <div class="col-12 pt-2">
                    <button type="button" id="changePasswordBtn"
                            class="btn btn-danger rounded-pill px-4 shadow-sm fw-semibold">
                        <i class="bi bi-lock-fill me-2"></i>Update Password
                    </button>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
.rounded-4 { border-radius: 1rem !important; }
</style>

<?php $this->registerJs(<<<JS
(function () {
    var btn  = document.getElementById('changePasswordBtn');
    var alert = document.getElementById('pwAlert');

    function showAlert(msg, type) {
        alert.className = 'alert alert-' + type + ' rounded-3 border-0 shadow-sm d-flex align-items-center gap-2 mb-3';
        var icon = type === 'success' ? 'bi-check-circle-fill' : 'bi-exclamation-triangle-fill';
        alert.innerHTML = '<i class="bi ' + icon + ' fs-5"></i><span>' + msg + '</span>';
    }

    btn.addEventListener('click', function () {
        var current = document.getElementById('current_password').value;
        var newPw   = document.getElementById('new_password').value;
        var confirm = document.getElementById('confirm_password').value;

        var fd = new FormData();
        fd.append('{$csrfParam}', '{$csrfToken}');
        fd.append('current_password', current);
        fd.append('new_password',     newPw);
        fd.append('confirm_password', confirm);

        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Saving...';

        fetch('{$changePasswordUrl}', { method: 'POST', body: fd })
            .then(function(r){ return r.json(); })
            .then(function(data) {
                if (data.success) {
                    showAlert(data.message, 'success');
                    document.getElementById('current_password').value = '';
                    document.getElementById('new_password').value     = '';
                    document.getElementById('confirm_password').value = '';
                } else {
                    showAlert(data.message, 'danger');
                }
            })
            .catch(function(){
                showAlert('An error occurred. Please try again.', 'danger');
            })
            .finally(function(){
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-lock-fill me-2"></i>Update Password';
            });
    });
})();
JS, \yii\web\View::POS_END); ?>
