<?php
/** @var $statusCounts array */
/** @var $totalCars    int */
/** @var $recentCars   \app\models\Car[] */
/** @var $client       \app\models\Client */
/** @var $uploadUrl    string */

$this->title = 'My Dashboard';
$baseUrl      = Yii::$app->request->baseUrl;
$defaultThumb = $baseUrl . '/uploads/cars/default.jpg';

$statList = [
    ['key' => 'at_auction', 'label' => 'At Auction', 'icon' => 'bi-hammer',            'color' => 'warning'],
    ['key' => 'at_yard',    'label' => 'At Yard',    'icon' => 'bi-building',           'color' => 'info'],
    ['key' => 'arrived',    'label' => 'Arrived',    'icon' => 'bi-check-circle-fill',  'color' => 'success'],
    ['key' => 'paid',       'label' => 'Paid',       'icon' => 'bi-cash-stack',         'color' => 'primary'],
    ['key' => 'unpaid',     'label' => 'Unpaid',     'icon' => 'bi-exclamation-circle', 'color' => 'danger'],
];

$statusMap = [
    'at_auction' => ['label' => 'At Auction', 'class' => 'bg-warning-subtle text-warning border border-warning-subtle'],
    'at_yard'    => ['label' => 'At Yard',    'class' => 'bg-info-subtle text-info border border-info-subtle'],
    'arrived'    => ['label' => 'Arrived',    'class' => 'bg-success-subtle text-success border border-success-subtle'],
    'paid'       => ['label' => 'Paid',       'class' => 'bg-primary-subtle text-primary border border-primary-subtle'],
    'unpaid'     => ['label' => 'Unpaid',     'class' => 'bg-danger-subtle text-danger border border-danger-subtle'],
];
?>

<div class="container-fluid py-3">

    <!-- Welcome -->
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-2">
        <div>
            <h4 class="fw-bold mb-0">
                Welcome back, <span class="text-primary"><?= htmlspecialchars($client->name ?? 'Client') ?></span>
            </h4>
            <p class="text-muted small mb-0">Client No: <strong><?= htmlspecialchars($client->no ?? '') ?></strong></p>
        </div>
        <a href="<?= \yii\helpers\Url::to(['/client/my-cars']) ?>"
           class="btn btn-primary rounded-pill px-4 shadow-sm fw-semibold">
            <i class="bi bi-car-front me-2"></i> View All My Cars
        </a>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-6 col-md-2">
            <div class="card border-0 shadow-sm rounded-4 h-100">
                <div class="card-body py-3 text-center">
                    <div class="fw-bold fs-3"><?= $totalCars ?></div>
                    <div class="small text-muted">Total Cars</div>
                    <span class="badge bg-secondary-subtle text-secondary rounded-pill mt-1"
                          style="font-size:0.65rem;">all</span>
                </div>
            </div>
        </div>
        <?php foreach ($statList as $s): ?>
        <div class="col-6 col-md-2">
            <div class="card border-0 shadow-sm rounded-4 h-100">
                <div class="card-body py-3 text-center">
                    <i class="bi <?= $s['icon'] ?> text-<?= $s['color'] ?> fs-4 d-block mb-1"></i>
                    <div class="fw-bold fs-4"><?= $statusCounts[$s['key']] ?? 0 ?></div>
                    <div class="small text-muted"><?= $s['label'] ?></div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- Recent Cars -->
    <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="card-header bg-white border-0 px-4 pt-4 pb-2 d-flex justify-content-between">
            <h6 class="fw-bold mb-0">
                <i class="bi bi-clock-history text-primary me-2"></i>Recent Vehicles
            </h6>
            <a href="<?= \yii\helpers\Url::to(['/client/my-cars']) ?>"
               class="small text-primary text-decoration-none">View all →</a>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0" style="font-size:0.855rem;">
                <thead class="bg-light">
                    <tr class="small text-muted text-nowrap">
                        <th class="ps-4">PHOTO</th>
                        <th>YEAR</th>
                        <th>VEHICLE INFO</th>
                        <th>LOT</th>
                        <th>CONTAINER</th>
                        <th>ETA</th>
                        <th>STATUS</th>
                        <th class="pe-4">ACTION</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($recentCars)): ?>
                    <tr>
                        <td colspan="8" class="text-center py-5 text-muted">
                            <i class="bi bi-inbox fs-2 d-block mb-2"></i>No vehicles found.
                        </td>
                    </tr>
                    <?php else: ?>
                    <?php foreach ($recentCars as $car):
                        $thumb = null;
                        foreach ($car->images as $img) {
                            if ($img->image_path) { $thumb = $img->image_path; break; }
                        }
                        $st = $statusMap[$car->status] ?? ['label' => $car->status, 'class' => 'bg-secondary-subtle text-secondary'];
                    ?>
                    <tr>
                        <td class="ps-4">
                            <img src="<?= $thumb ? $uploadUrl . htmlspecialchars($thumb) : $defaultThumb ?>"
                                 width="60" height="44"
                                 class="rounded-2 border shadow-sm"
                                 style="object-fit:cover;"
                                 onerror="this.src='<?= $defaultThumb ?>'">
                        </td>
                        <td class="fw-bold"><?= htmlspecialchars($car->year) ?></td>
                        <td style="max-width:160px;">
                            <div class="text-truncate" title="<?= htmlspecialchars($car->info) ?>">
                                <?= htmlspecialchars($car->info) ?>
                            </div>
                        </td>
                        <td class="fw-semibold"><?= htmlspecialchars($car->lot) ?></td>
                        <td><?= htmlspecialchars($car->container ?: '—') ?></td>
                        <td class="text-nowrap">
                            <?= $car->eta_date ? date('d/m/Y', strtotime($car->eta_date)) : '—' ?>
                        </td>
                        <td>
                            <span class="badge rounded-pill px-3 py-2 <?= $st['class'] ?>">
                                <?= $st['label'] ?>
                            </span>
                        </td>
                        <td class="pe-4">
                            <a href="<?= \yii\helpers\Url::to(['/client/view-car', 'id' => $car->id]) ?>"
                               class="btn btn-sm btn-outline-primary border-0 rounded-pill">
                                <i class="bi bi-eye me-1"></i>View
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<style>
.rounded-4 { border-radius: 1rem !important; }
.table th {
    font-size: 0.75rem; font-weight: 600;
    text-transform: uppercase; letter-spacing: 0.5px;
    padding-top: 1rem; padding-bottom: 1rem;
}
</style>
