<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Car;

/**
 * CarSearch represents the model behind the search form of `app\models\Car`.
 */
class CarSearch extends Car
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'auction_id', 'warehouse_id', 'destination_id', 'client_id', 'user_id'], 'integer'],
            [['vin', 'lot', 'title', 'info', 'liner', 'year', 'status', 'purchase_date', 'received_date', 'eta_date', 'shipping_line', 'container', 'note', 'created'], 'safe'],
            [['price'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     * @param string|null $formName Form name to be used into `->load()` method.
     *
     * @return ActiveDataProvider
     */
    public function search($params, $formName = null)
    {
        $query = Car::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params, $formName);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'price' => $this->price,
            'auction_id' => $this->auction_id,
            'warehouse_id' => $this->warehouse_id,
            'destination_id' => $this->destination_id,
            'client_id' => $this->client_id,
            'user_id' => $this->user_id,
            'purchase_date' => $this->purchase_date,
            'received_date' => $this->received_date,
            'eta_date' => $this->eta_date,
            'created' => $this->created,
        ]);

        $query->andFilterWhere(['like', 'vin', $this->vin])
            ->andFilterWhere(['like', 'lot', $this->lot])
            ->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'info', $this->info])
            ->andFilterWhere(['like', 'liner', $this->liner])
            ->andFilterWhere(['like', 'year', $this->year])
            ->andFilterWhere(['like', 'status', $this->status])
            ->andFilterWhere(['like', 'shipping_line', $this->shipping_line])
            ->andFilterWhere(['like', 'container', $this->container])
            ->andFilterWhere(['like', 'note', $this->note]);

        return $dataProvider;
    }
}
