<?php

namespace app\models;

use yii\db\ActiveRecord;

class CarImage extends ActiveRecord
{
    /**
     * ✅ CRITICAL: your SQL dump shows table is "car_image" (singular)
     * NOT "car_images" (plural)
     */
    public static function tableName()
    {
        return 'car_image';
    }

    // ============================================================
    //  RELATIONS
    // ============================================================

    public function getCar()
    {
        return $this->hasOne(Car::class, ['id' => 'car_id']);
    }

    // ============================================================
    //  RULES
    // ============================================================

    public function rules()
    {
        return [
            // Required
            [['car_id', 'type'], 'required'],

            // Integer
            [['car_id'], 'integer'],

            // Strings — matches your DB varchar(255)
            [['image_path', 'type'], 'string', 'max' => 255],

            // ✅ Type values used in CarController: auction, warehouse, loading
            ['type', 'in', 'range' => ['auction', 'warehouse', 'loading']],

            // Nullable image_path
            [['image_path'], 'default', 'value' => null],
        ];
    }

    // ============================================================
    //  LABELS
    // ============================================================

    public function attributeLabels()
    {
        return [
            'id'         => 'ID',
            'car_id'     => 'Car',
            'image_path' => 'Image Path',
            'type'       => 'Type',
        ];
    }
}
