<?php

namespace app\controllers;

use Yii;
use app\models\Car;
use app\models\Client;

class AdminController extends BaseController
{
    // ✅ No behaviors() needed — BaseController handles all access control.
    // Admin-only access is enforced automatically because only 'admin'
    // position gets through to any non-whitelisted route.

    public function actionIndex()
    {
        $totalCars    = Car::find()->count();
        $totalClients = Client::find()->count();
        $paidCars     = Car::find()->where(['status' => 'paid'])->count();
        $unpaidCars   = Car::find()->where(['status' => 'unpaid'])->count();

        $recentCars = Car::find()
            ->orderBy(['id' => SORT_DESC])
            ->limit(5)
            ->all();

        return $this->render('index', [
            'totalCars'    => $totalCars,
            'totalClients' => $totalClients,
            'paidCars'     => $paidCars,
            'unpaidCars'   => $unpaidCars,
            'recentCars'   => $recentCars,
        ]);
    }
}
