<?php

/**
 * @link https://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license https://www.yiiframework.com/license/
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        // Local AdminLTE CSS
        'dist/css/adminlte.min.css',
        // Icons (You can keep CDN for icons or download them too)
        'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css',
        'css/site.css',
    ];
    public $js = [
        // Local AdminLTE JS
        'dist/js/adminlte.min.js',
        // Dependencies (Required for Bootstrap 5 & AdminLTE 4)
        'https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js',
        // Vue 3 Core (Keep CDN for now for easy updates)
        'https://unpkg.com/vue@3/dist/vue.global.js',
        'https://unpkg.com/axios/dist/axios.min.js',
    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\bootstrap5\BootstrapAsset'
    ];
}
